#include <iostream>
#include <vector>
#include <unordered_map>
#include <unordered_set>

using namespace std;

#define MAX 1000000000

typedef long long ll;

ll getID(pair<int, int> p){
  return ((p.first) + MAX) * (2 * MAX) + (p.second) + MAX;
}

int main(){
  ios_base::sync_with_stdio(false), cin.tie(0);
  
  int n; cin>>n;
  vector<pair<int, int>> vec(n);
  unordered_map<int, int> xCtrEven, xCtrOdd, yCtrEven, yCtrOdd;
  unordered_set<ll> set;

  ll res = 0;

  for (int i = 0; i < n; ++i){
    cin>>vec[i].first>>vec[i].second;

    int x = vec[i].first, y = vec[i].second;

    if (x % 2)
      ++xCtrOdd[x];
    else
      ++xCtrEven[x];

    if (y % 2)
      ++yCtrOdd[y];
    else
      ++yCtrEven[y];

    set.insert(getID(vec[i]));
  }

  for (auto p: vec){
    int add = 1;

    while ((add & (1 << 31)) == 0){
      if (set.find(getID({p.first + add, p.second + add})) != set.end())
        res += 2;

      if (set.find(getID({p.first - add, p.second + add})) != set.end())
        res += 2;

      add<<=1;
    }

    if (p.first % 2)
      res += xCtrOdd[p.first] - 1;
    else
      res += xCtrEven[p.first] - 1;

    if (p.second % 2)
      res += yCtrOdd[p.second] - 1;
    else
      res += yCtrEven[p.second] - 1;
  }

  cout<<res;

  return 0;
}